﻿var mediaSelector = {
    context: $(".v-imageSelector"),
    selectorContainer: null,
    uploaderContainer: null,
    currentCategoryId: null,
    currentCategoryName: null,
    currentSelectionFullPath: null,
    selectedUrlInput: null,
    tempSelectedItem: null,
    tempSelectedItemUrl: null,
    uploadFormIsInit: false,
    loadedImages: [],
    totalImages: 0,
    pageStart: 0,
    pageLength: 28,
    mediaType: 0,
    handleDefaultItemSelection: function () {
        if (mediaSelector.selectedItemId !== "0")
        {
            selectedItem = $.grep(this.loadedImages, function (e) { return e.Id == mediaSelector.selectedItemId; })[0];

            if (selectedItem)
            {
                this.currentCategoryId = selectedItem.CategoryId;
                this.currentSelectionFullPath = mediaSelector.path + selectedItem.Url;
                this.displaySelectionUrl(selectedItem.Url);
                this.currentCategoryName = $.grep(mediaSelector.imageCategories, function (e) { return e.Id == mediaSelector.currentCategoryId; })[0].Name;
                $(".h-categories-autocomplete", mediaSelector.context).val(this.currentCategoryName);
            }
        }
    },
    setMediaUploadFunctions: function () {
        var header = this.selectorContainer.siblings(".v-header").first();
        var addLink = header.find(".h-addNewMediaFile");

        addLink.on("click", function () {
            mediaSelector.toggleElementsDisabilityOnUpload(true);

            mediaSelector.selectorContainer.hide(function () {
                mediaSelector.uploaderContainer.show(function () {
                    if (!mediaSelector.uploadFormIsInit) {
                        mediaUpload.uploaderContainer = mediaSelector.uploaderContainer;
                        mediaUpload.submitButton = $(".v-footerUpload .h-uploadSubmitButton", mediaSelector.context);
                        mediaUpload.cancelButton = $(".v-footerUpload .h-uploadCancelButton", mediaSelector.context);
                        mediaUpload.controllerName = "Shared";
                        mediaUpload.isExternalSource = mediaSelector.isExternalSource;

                        $(".v-footerUpload .h-uploadCancelButton", mediaSelector.context).on("click", function () {
                            mediaSelector.uploaderContainer.hide(function () {
                                mediaSelector.selectorContainer.show(function () {
                                    mediaSelector.toggleElementsDisabilityOnUpload(false);
                                });
                            });
                        });

                        mediaUpload.initMediaUploadControls();
                    }
                });
            });

            return false;
        });
    },
    toggleElementsDisabilityOnUpload: function (disable) {
        var header = this.selectorContainer.siblings(".v-header").first();
        var footerSelector = this.selectorContainer.siblings(".v-footerSelector").first();
        var footerUpload = this.selectorContainer.siblings(".v-footerUpload").first();
        var categoriesAutoComplete = header.find(".h-categories-autocomplete");
        var searchBox = header.find(".v-searchBox");
        var addFileButton = header.find(".h-addNewMediaFile");
        var confirmButton = footerSelector.find(".v-confirmButton");

        categoriesAutoComplete.prop('disabled', disable);
        searchBox.prop('disabled', disable);

        if (disable) {
            addFileButton.addClass("disabled");
            categoriesAutoComplete.a4autocomplete("disable");
            footerSelector.hide();
            footerUpload.show();
        }
        else {
            addFileButton.removeClass("disabled");
            categoriesAutoComplete.a4autocomplete("enable");
            footerSelector.show();
            footerUpload.hide();
        }
    },
    displaySelectionUrl: function (url) {
        var footer = this.selectorContainer.siblings(".v-footerSelector").first();
        var footerInfo = footer.find(".v-info");
        footerInfo.text(url);
    },
    setCategorySelectionFunctions: function () {
        var imageCategoriesWithDefault = [{ "Id": "", "Name": languageResources.All }].concat(mediaSelector.allImageCategories);
        var header = this.selectorContainer.siblings(".v-header").first();

        $(".h-categories-autocomplete", mediaSelector.context).a4autocomplete({
            valueProperty: "Id",
            labelProperty: "Name",
            displayDeleteItem: "mediaUpload.isExternalSource && ![BaseCategory]",            
            data: imageCategoriesWithDefault,
            select: function (event, ui) {
                mediaSelector.currentCategoryId = ui.item.Id;
                mediaSelector.currentCategoryName = ui.item.Name;
                mediaSelector.loadImages(true);
            },
            deleteItem: function (event, data) {
                var self = $(this);
                
                // Do not delete All category
                if (data.item && data.item.Id != "0") {
                    modalDialog.showConfirmDialog(confirmDeleteCategoryResources, function () {
                        a4.callServerMethod(a4.getAction("DeleteExternalImageCategory", "MultiMode", "Home"), {
                            imageId: data.item.Id
                        },
                        function (result) {
                            imageCategoriesWithDefault = _.reject(imageCategoriesWithDefault, function (r) { return r.Id == data.item.Id; });
                           
                            $(".h-categories-autocomplete", mediaSelector.context).autocomplete('option', 'source', imageCategoriesWithDefault);
                            $(".h-categories-autocomplete", mediaSelector.context).a4autocomplete("setValue", "");
                        });
                    }, 220, 500, false, { "category": data.item.Name });
                }
            }
        }).val(imageCategoriesWithDefault[0].Name);
    },
    bindEvents: function () {
        mediaSelector.context.on("click", ".h-cancelButton", function () {
            mediaSelector.selectedUrlInput.val("");
            mediaSelector.tempSelectedItem = null;
            modalDialog.close();
        });

        mediaSelector.context.on("click", ".v-confirmButton", function () {
            mediaSelector.selectedUrlInput.val(mediaSelector.tempSelectedItem).attr("data-url", mediaSelector.tempSelectedItemUrl);
            modalDialog.close();
        });

        mediaSelector.context.on("click", ".h-filterButton", function () {
            mediaSelector.loadImages(true);
        });

        mediaSelector.context.on("keypress", ".v-searchBox", function (e) {
            var code = (e.keyCode ? e.keyCode : e.which);

            if (code == 13) {
                mediaSelector.loadImages(true);
                e.preventDefault();
            }
        });

        mediaSelector.context.on("click", ".h-imageItem", function () {
            mediaSelector.selectItem($(this));
        });

        mediaSelector.context.on("click", ".h-deleteImage", function () {
            mediaSelector.deleteItem($(this).closest(".h-imageItem"));
        });

        mediaSelector.context.on("dblclick", ".h-imageItem", function () {
            mediaSelector.selectItem($(this));
            $(".v-confirmButton", mediaSelector.context).trigger("click");
        });

        mediaSelector.context.on("click", ".h-pagerBack", function () {
            mediaSelector.pageStart -= mediaSelector.pageLength;
            mediaSelector.loadImages();
        });

        mediaSelector.context.on("click", ".h-pagerNext", function () {
            mediaSelector.pageStart += mediaSelector.pageLength;
            mediaSelector.loadImages();
        });
        
        mediaSelector.context.on("click", ".h-addNewMediaCategory", function () {
            modalDialog.showWindow(a4.getAction("EditCategory", "MultiMode"), 250, 600, {
                afterClose: function () {
                    a4.callServerMethod(a4.getAction("GetMediaExternalCategories", "Shared", "Home"), {}, function (result) {
                        var imageCategoriesWithDefault = [{ "Id": "", "Name": languageResources.All }].concat(result.allCategories);
                        $(".h-categories-autocomplete", mediaSelector.context).autocomplete('option', 'source', imageCategoriesWithDefault);
                        $(".h-categories-autocomplete", mediaSelector.context).a4autocomplete("setValue", "");

                        mediaSelector.imageCategories = result.categories;
                    });
                }
            });
        });
    },
    selectItem: function (item) {
        var itemId = item.attr("data-id");
        mediaSelector.selectedItemId = itemId;

        this.deselectPreviousItem();
        item.addClass("selected");

        var selectedItemUrl = $.grep(this.loadedImages, function (e) { return e.Id == mediaSelector.selectedItemId; })[0].Url;
        this.displaySelectionUrl(selectedItemUrl);

        if (mediaSelector.isExternalSource || this.isExternalUrl(selectedItemUrl))
            this.tempSelectedItem = selectedItemUrl;
        else
            this.tempSelectedItem = mediaSelector.path + selectedItemUrl;

        this.tempSelectedItemUrl = mediaSelector.path + selectedItemUrl;
    },
    deleteItem: function (item) {
        var itemId = item.attr("data-id");
        var name = $(".name", item).text()
        this.selectItem(item);

        modalDialog.showConfirmDialog(confirmDeleteImageResources, function () {
            a4.callServerMethod(a4.getAction("DeleteExternalImage", "Shared"), { imageId: itemId },
            function (result) {
                mediaSelector.loadImages();
            });
        }, 250, 500, true, { "image": name });
    },
    deselectPreviousItem: function () {
        $(".v-selectorContainer .selected").each(function () {
            $(this).removeClass("selected");
        });
    },
    loadImages: function (resetPager) {
        var header = this.selectorContainer.siblings(".v-header").first();
        var searchValue = $(".v-searchBoxContainer .v-searchBox", header).val();
        var itemList = $("ul", this.selectorContainer);

        if (resetPager)
            mediaSelector.resetPager(searchValue);

        var action = mediaSelector.isExternalSource ? "GetExternalMultimediaFiles" : "GetMultimediaFiles";

        a4.callServerMethod(a4.getAction(action, "Shared"), {
            "categoryId": mediaSelector.currentCategoryId, mediaType: mediaSelector.mediaType, "search": searchValue,
            "pageStart": mediaSelector.pageStart, "pageLength": mediaSelector.pageLength, "pageIndex": (mediaSelector.pageStart / mediaSelector.pageLength + 1)
        },
        function (result) {
            mediaSelector.loadedImages = result;

            itemList.empty();

            _.each(result, function (imageItem) {
                var imageFullUrl = imageItem.Url;
                var classString = "";

                if (imageItem.Id == mediaSelector.selectedItemId)
                    classString = " selected";

                if (imageItem.MediaTypeName == 2)
                {
                    imageFullUrl = "../../Content/Images/Thumbnails/video_02.png";
                }
                else if (!(mediaSelector.isExternalUrl(imageItem.Url)))
                {
                    imageFullUrl = mediaSelector.path + imageFullUrl;
                }

                var listItem = $("<li/>", { "data-id": imageItem.Id, "title": imageItem.Description, "class": "h-imageItem " + classString });
                var listItemImage = $("<span />", { "class": "image" }).append($("<img />", { "src": imageFullUrl, "alt": imageItem.Name, "data-url": imageItem.Url }));
                var listItemName = $("<span />", { "class": "name" }).text(imageItem.Name);

                itemList.append(listItem.append(listItemImage).append(listItemName).append((mediaSelector.isExternalSource && !imageItem.IsBaseCategory) ? voxco.icons.getIcon("delete", "h-deleteImage", { "Title": sharedResources.Delete }) : ""));
            });

            mediaSelector.togglePagerButtons(result.length);
        });
    },
    resetPager: function (searchValue) {
        mediaSelector.pageStart = 0;
        var action = mediaSelector.isExternalSource ? "GetExternalMultimediaFilesCount" : "GetMultimediaFilesCount";

        a4.callServerMethod(a4.getAction(action, "Shared"), { "categoryId": mediaSelector.currentCategoryId, mediaType: mediaSelector.mediaType, "search": searchValue },
            function (result) {
                mediaSelector.totalImages = result;
                $(".v-pager", mediaSelector.selectorContainer).toggle(mediaSelector.totalImages > mediaSelector.pageLength);
            }, function () { }, { "async": false });
    },
    togglePagerButtons: function (loadedItems) {
        if (loadedItems > 0)
        {
            var pageEnd = mediaSelector.pageStart + loadedItems;

            $(".v-pagerInfo", mediaSelector.selectorContainer).text(resources.Info.replace(/_START_/g, mediaSelector.pageStart + 1).replace(/_END_/g, pageEnd).replace(/_TOTAL_/g, mediaSelector.totalImages));
            $(".h-pagerBack", mediaSelector.selectorContainer).toggle(mediaSelector.pageStart >= mediaSelector.pageLength);
            $(".h-pagerNext", mediaSelector.selectorContainer).toggle(pageEnd < mediaSelector.totalImages);
        }
    },
    isExternalUrl: function (fileUrl) {
        return fileUrl ? (fileUrl.toLowerCase().substring(0, 7) == "http://" || fileUrl.toLowerCase().substring(0, 8) == "https://") : false;
    }
}

$(document).ready(function () {
    if (mediaSelector.context.length > 0)
    {
        mediaSelector.currentCategoryId = null;
        mediaSelector.selectorContainer = $(".v-selectorContainer", mediaSelector.context);
        mediaSelector.uploaderContainer = $(".v-uploaderContainer", mediaSelector.context);
        mediaSelector.selectedUrlInput = $("#v-selectedURL", mediaSelector.context);
        mediaSelector.mediaType = $("#MediaType", mediaSelector.context).val();

        mediaSelector.setCategorySelectionFunctions();
        mediaSelector.setMediaUploadFunctions();
        mediaSelector.handleDefaultItemSelection();

        mediaSelector.loadImages(true);
        mediaSelector.bindEvents();
    }
});